class DynamicLoader extends HTMLElement {
    constructor() {
      super();
      this.attachShadow({ mode: 'open' });
      let loadCount = parseInt(localStorage.getItem('loaderCount')) || 0;
      let nombrechargement = 4;
      
      if (loadCount < nombrechargement) {
        localStorage.setItem('loaderCount', loadCount + 1);
        this.style.display = 'none'; // Cache le loader
        document.addEventListener('DOMContentLoaded', () => {
          document.querySelector('.contenu').style.display = 'block';
        });
        return;
      } else {
        // Réinitialise le compteur de chargements après 10
        localStorage.setItem('loaderCount', 1);
      }

      // Création de la structure HTML interne
      const container = document.createElement('div');
      container.classList.add('loader-container');
      container.innerHTML = `
        <div class="overflow-hidden">
          <h1 class="heading">
            <span class="char">P</span>
            <span class="char">o</span>
            <span class="char">r</span>
            <span class="char">t</span>
            <span class="char">f</span>
            <span class="char">o</span>
            <span class="char">l</span>
            <span class="char">i</span>
            <span class="char">o</span>
          </h1>
          
          <h1 class="heading">
            <p> Mathéo CHUPIN </p>
          </h1>
        </div>
      `;
  
      // Style interne du composant
      const style = document.createElement('style');
      style.textContent = `
        @import url('https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap');

        .loader-container {
          position: fixed;
          top: 0;
          left: 0;
          width: 100vw;
          height: 100vh;
          background-color: rgba(51, 51, 51, 1);
          display: flex;
          flex-direction: column;
          align-items: center;
          justify-content: center;
          z-index: 1000;
        }

        .overflow-hidden {
          overflow: hidden;
        }

        .heading {
          font-size: 5rem;
          font-weight: 200;
          color: antiquewhite;
          display: flex;
          justify-content: center;
          width: 100%;
          margin: 0px;
        }

        p {
          font-size: 2rem;
          font-weight: 100;
          color: antiquewhite;
          font-family: 'Montserrat';
          text-align: center;
          margin-top: 0; /* Ajout d'un espace entre le titre et le nom */
        }

        .char {
          font-family: 'Montserrat';
          display: inline-block;
          font-weight: 200;
          transition: font-weight 0.5s ease;
        }
      `;
  
      // Ajouter le style et le HTML au Shadow DOM
      this.shadowRoot.append(style, container);
    }
  
    connectedCallback() {
      const chars = this.shadowRoot.querySelectorAll(".char");
  
      function animateWeight(target, from, to, duration) {
        let start = null;
  
        function step(timestamp) {
          if (!start) start = timestamp;
          const progress = Math.min((timestamp - start) / duration, 1);
          target.style.fontWeight = from + (to - from) * progress;
  
          if (progress < 1) {
            requestAnimationFrame(step);
          }
        }
  
        requestAnimationFrame(step);
      }
  
      chars.forEach((char, index) => {
        char.addEventListener("mouseenter", () => {
          animateWeight(char, 200, 500, 300);
          if (chars[index - 1]) animateWeight(chars[index - 1], 200, 350, 300);
          if (chars[index + 1]) animateWeight(chars[index + 1], 200, 350, 300);
        });
  
        char.addEventListener("mouseleave", () => {
          animateWeight(char, 500, 200, 300);
          if (chars[index - 1]) animateWeight(chars[index - 1], 350, 200, 300);
          if (chars[index + 1]) animateWeight(chars[index + 1], 350, 200, 300);
        });
      });
  
      chars.forEach((char, index) => {
        gsap.fromTo(
          char,
          { fontWeight: 200 },
          {
            fontWeight: 1000,
            duration: 0.3,
            ease: "power1.out",
            delay: index * 0.1,
            onComplete: () => {
              gsap.to(char, { fontWeight: 200, duration: 0.3, ease: "power1.in" });
              if (index === chars.length - 1) {
                setTimeout(() => {
                  this.style.display = 'none'; // Cache le loader une fois l'animation terminée
                  document.querySelector('.contenu').style.display = 'block'; // Affiche le contenu principal
                }, 500); // Délai pour assurer la fin des animations
              }
            }
          }
        );
      });
    }
  }
  
  // Déclaration du composant personnalisé
  customElements.define('dynamic-loader', DynamicLoader);
  
  /* Pour utiliser le loader :
  head : 
    <script src="./testVariable3loader.js" defer></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.10.4/gsap.min.js"></script>

  body :
    <dynamic-loader></dynamic-loader>
    <div class="contenu">
    Avec ici tout le contenu de la page
    </div>
  


  POur mon nom prénom en anim :
            <span class="char">M</span>
            <span class="char">a</span>
            <span class="char">t</span>
            <span class="char">h</span>
            <span class="char">é</span>
            <span class="char">o</span>
            <span class="char">&nbsp</span>
            <span class="char">C</span>
            <span class="char">H</span>
            <span class="char">U</span>
            <span class="char">P</span>
            <span class="char">I</span>
            <span class="char">N</span>
  */