// Créer le filtre et l'ajouter au DOM
const filter = document.createElement('div');
filter.id = 'filter';
document.body.appendChild(filter);

const sections = document.querySelectorAll('.section');
let sectionPositions = [];
let highlightedSection = null;

// Fonction pour recalculer les positions de chaque section
function updateSectionPositions() {
  sectionPositions = Array.from(sections).map(section => {
    const rect = section.getBoundingClientRect();
    return {
      element: section,
      top: rect.top + window.scrollY,
      bottom: rect.bottom + window.scrollY,
      height: rect.height
    };
  });
}

// Fonction pour surligner la section sous la souris et mettre à jour la position du filtre
function updateHighlight(event) {
  const mouseY = event.pageY;
  let newHighlightedSection = null;

  // Déterminer la section sur laquelle la souris est située
  for (const pos of sectionPositions) {
    if (mouseY >= pos.top && mouseY <= pos.bottom) {
      newHighlightedSection = pos.element;
      break;
    }
  }

  // Applique la classe highlight si une nouvelle section est survolée
  if (newHighlightedSection !== highlightedSection) {
    sections.forEach(section => {
      if (section === newHighlightedSection) {
        section.classList.add('highlight');
      } else {
        section.classList.remove('highlight');
      }
    });

    highlightedSection = newHighlightedSection;
  }

  // Met à jour la position du filtre en fonction de la section surlignée
  updateFilterPosition();
}

// Fonction pour mettre à jour la position du filtre
function updateFilterPosition() {
  if (highlightedSection) {
    const rect = highlightedSection.getBoundingClientRect();
    filter.style.top = `${rect.top + window.scrollY - window.scrollY}px`;
    filter.style.height = `${rect.height}px`;
    filter.style.opacity = '1';
  } else {
    filter.style.opacity = '0'; // Masque le filtre s'il n'y a pas de section surlignée
  }
}

// Initialise les positions au chargement de la page
updateSectionPositions();

// Met à jour les positions au redimensionnement
window.addEventListener('resize', updateSectionPositions);

// Met à jour le filtre en fonction du défilement
window.addEventListener('scroll', () => {
  updateSectionPositions();
  updateFilterPosition();
});

// Met à jour le surlignage lors du mouvement de la souris
document.addEventListener('mousemove', updateHighlight);

// Masque le filtre si la souris quitte la fenêtre
document.addEventListener('mouseleave', () => {
  filter.style.opacity = '0';
});
